﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="productdigitallist.ascx.vb" Inherits="ASPNetPortal.productdigitallist" %>
<%@ Register TagPrefix="ew" Namespace="eWorld.UI" Assembly="eWorld.UI" %>
<div id="orderlist" class="module">
    <% If HeaderVisible Then%>
    <div class="moduleTitle">
        <%=ModuleTitle%>
        <% If IsEditable Then%>
        <a href="<%=EditNavigateUrl %>" class="moduleTitleEdit"><%=EditText %></a>
        <% End If%>
    </div>
    <% End If%>
    <div class="moduleContent moduleContentCol1 clearFix">
        <div class="formContent clearFix">
            <div class="moduleContentCol3">
                <label><%=GetGlobalResourceObject("lang", "ProductName")%></label>
                <asp:TextBox ID="txtOrderId" runat="server"></asp:TextBox>
            </div>
            <div class="moduleContentCol3">
                <label><%=GetGlobalResourceObject("lang", "Status")%></label>
                <asp:DropDownList ID="ddlStatus" runat="server"></asp:DropDownList>
            </div>
            <div class="moduleContentCol3">
                <label><%=GetGlobalResourceObject("lang", "PaymentType")%></label>
                <asp:DropDownList ID="ddlPaymentType" runat="server"></asp:DropDownList>
            </div>
            <div class="moduleContentCol3 inputButton">
                <label><%=GetGlobalResourceObject("lang", "StartDate")%> > </label>
                <ew:CalendarPopup ID="Tarih1" runat="server" GoToTodayText="Bu Gün:" ClearDateText="Sil" ShowGoToToday="True" Nullable="True"></ew:CalendarPopup>
            </div>
            <div class="moduleContentCol3 inputButton">
                <label><%=GetGlobalResourceObject("lang", "EndDate")%> < </label>
                <ew:CalendarPopup ID="tarih11" runat="server" GoToTodayText="Bu Gün:" ClearDateText="Sil" ShowGoToToday="True" Nullable="True"></ew:CalendarPopup>
            </div>
            <div class="moduleContentCol3">
                <label>&nbsp;</label>
                <asp:Button ID="btnSearch" runat="server" CssClass="button" Text="<%$ Resources:lang, Search%>" />
            </div>
        </div>
        <label>
            <asp:Label ID="msg" runat="server" Visible="False"></asp:Label></label>
        <div class="dataTable">
            <asp:DataGrid ID="Datagrid1" runat="server" AllowPaging="True" AutoGenerateColumns="False" AllowSorting="True" CssClass="datalist" HeaderStyle-CssClass="title" GridLines="none" ItemStyle-CssClass="row">
                <Columns> 
                     <asp:BoundColumn Visible="False" DataField="DownloadFileName" HeaderText="DownloadFileName"></asp:BoundColumn>
                    <asp:BoundColumn Visible="False" DataField="FileName" HeaderText="FileName"></asp:BoundColumn>
                    <asp:BoundColumn Visible="False" DataField="ContentType" HeaderText="ContentType"></asp:BoundColumn>
                    <asp:BoundColumn Visible="False" DataField="ProductId" HeaderText="ProductId"></asp:BoundColumn>
                    <asp:BoundColumn Visible="False" DataField="Extension" HeaderText="Extension"></asp:BoundColumn>
                    <asp:BoundColumn Visible="False" DataField="IND" HeaderText="IND"></asp:BoundColumn>
                    <asp:BoundColumn  DataField="ProductName" HeaderText="Ürün Adı"></asp:BoundColumn>
                    <asp:TemplateColumn Visible="false" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" HeaderStyle-Wrap="false" HeaderText="<%$ Resources:lang, OrderId%>">
                        <ItemTemplate>
                         	<a id="lnkCompare" class="lightbox buttonLink" href='<%# BaseUrl & "/store/orderdetail.aspx?IND=" & DataBinder.Eval(Container.DataItem,"OrderCode") & "&MID=0" %>'>
                               <%# Eval("OrderCode")%>
                            </a>
                        </ItemTemplate>
                    </asp:TemplateColumn> 
                     <asp:TemplateColumn  HeaderStyle-Wrap="false"  SortExpression="Status" HeaderText="<%$ Resources:lang,Status %>">
                                <ItemTemplate><span class="Status Status<%#Eval("Status")%>"><%#Eval("StatusName")%></span></ItemTemplate>
                            </asp:TemplateColumn>
                    <asp:BoundColumn DataField="OrderDate" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" DataFormatString="{0:d}" HeaderStyle-Wrap="false" HeaderText="<%$ Resources:lang, OrderDate%>" SortExpression="OrderDate"></asp:BoundColumn>
                    <asp:BoundColumn DataField="PaymentType" HeaderStyle-Wrap="false" HeaderText="<%$ Resources:lang, PaymentType%>" SortExpression="PaymentType"></asp:BoundColumn>
                    <asp:BoundColumn Visible="false" DataField="BankaToplamTutar" HeaderStyle-HorizontalAlign="Right" DataFormatString="{0:0.00 &quot;TL&quot;}" HeaderStyle-Wrap="false" SortExpression="BankaToplamTutar" HeaderText="<%$ Resources:lang, TotalPrice%>">
                        <ItemStyle HorizontalAlign="Right"></ItemStyle>
                    </asp:BoundColumn>
                    <asp:TemplateColumn HeaderText="Puanla">
                        <ItemTemplate>
                            <a id="lnkaddreview" class="lightbox button iButton" href='<%# BaseUrl & "/store/addreviewdigital.aspx?productID=" & DataBinder.Eval(Container.DataItem, "ProductId")%>'> <i class="icon-comment"></i></a>                             
                        </ItemTemplate>
                    </asp:TemplateColumn>
                    <asp:TemplateColumn HeaderText="İndir">
                        <ItemTemplate>
                            <asp:LinkButton runat="server" CssClass="button iButton" ID="lnk"  CommandArgument="<%# Container.DataItem %>" CommandName="Delete" >
                                <i class="icon-download"></i>
                           </asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateColumn>
                </Columns>
                <PagerStyle PageButtonCount="20" Mode="NumericPages" CssClass="dataPager"></PagerStyle>
            </asp:DataGrid>
        </div>

        <div class="dataCount">
            <ul>
                <li><%=GetGlobalResourceObject("lang", "TotalRecords")%> : <b>
                    <asp:Label ID="lblTotalRecord" CssClass="textRed" runat="server"></asp:Label></b></li>
                <li><%=GetGlobalResourceObject("lang", "TotalPages")%> : <b>
                    <asp:Label ID="lblPageCount" CssClass="textRed" runat="server"></asp:Label></b></li>
                <li><%=GetGlobalResourceObject("lang", "CurrentPage")%> : <b>
                    <asp:Label ID="lblCurrentIndex" CssClass="textRed" runat="server"></asp:Label></b></li>
            </ul>
        </div>
        <asp:Label ID="lblSort" runat="server" Visible="False"></asp:Label>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $(".lightbox").colorbox({ width: "900", height: "400", iframe: true, scrolling: false });
    });
    $(document).ready(function () {
        $(".lightbox2").colorbox({ width: "1200", height: "950", iframe: true, scrolling: false });
    });

</script>

