﻿<%@ Control Language="vb" AutoEventWireup="false" EnableViewState="False" CodeBehind="top10group.ascx.vb" Inherits="ASPNetPortal.top10group" %>

<%@ Import Namespace="System.Data.SqlClient" %>


<div class="module widget-company-group">
    <div class="wdgt-cmpny-title clearFix">
        <% If HeaderVisible Then%>
        <div class="title">
            <i class="icon-star-2"></i><%=ModuleTitle%>
            <% If IsEditable Then%>
            <a href="<%=EditNavigateUrl %>" class="moduleTitleEdit"><%=EditText %></a>
            <% End If%>
        </div>
        <% End If%>

        <div class="tab-title">
            <asp:Repeater runat="server" ID="rptTabName">
                <HeaderTemplate>
                    <ul class="tabs">
                </HeaderTemplate>
                <ItemTemplate>
                    <li class="tab-link <%#IIf(Eval("FirstSelect") = True, "active", "")%>" data-tab="tab-<%#Eval("TabId")%>">
                        <h3><%#Eval("TabName") %></h3>
                    </li>
                </ItemTemplate>
                <FooterTemplate>
                    </ul>
                </FooterTemplate>
            </asp:Repeater>
        </div>
    </div>

    <div class="tabs-content">
        <asp:Repeater runat="server" ID="rptBindTab">
            <ItemTemplate>
                <asp:Repeater ID="rptCatTopProducts" runat="server" DataSource='<%# LoadCategoryPageProducts(ChkNullInteger(Eval("TabCatId"))) %>'>
                    <HeaderTemplate>
                        <div id="tab-<%# DataBinder.Eval(Container.Parent.Parent, "DataItem.TabId")%>" class="tab-content <%#IIf(DataBinder.Eval(Container.Parent.Parent, "DataItem.FirstSelect") = True, "active", "")%>">
                            <div class="owl-company-products">
                    </HeaderTemplate>

                    <ItemTemplate>
                        <div class="item clearFix">
                            <a href="<%# string.format(BaseUrl & "{0}" & ".aspx",Container.DataItem("ProductUrl").tostring.Remove(Container.DataItem("ProductUrl").tostring.Length - 1, 1)) %>">
                                <span class="image">
                                    <img src="<%# BaseUrl & "/store/makethumb.aspx?file=" & Eval("Path")%> &amp;intSize=123" />
                                </span>

                                <span class="name"><%# Eval("ProductName") %></span>

                                <% If (ConfigurationManager.AppSettings("OnlyUsersCanSeePrice") = "True" And HttpContext.Current.User.Identity.IsAuthenticated()) Or ConfigurationManager.AppSettings("OnlyUsersCanSeePrice") <> "True" Then%>
                                <% If SeePrice() Then%>
                                <div id="homelabels">
                                    <div id="IndirimliUrun" style="display: <%# iif((eval("IndirimliUrun")) and (ChkNullToDecimal(Eval("PiyasaFiyati")) > 0) ,"block;","none;") %>">
                                        %<%#CInt(GetPercent(ChkNullToDecimal(Eval("PiyasaFiyati")),ChkNullToDecimal(Eval("SatisFiyati")))) %>
                                        <span><%=GetGlobalResourceObject("lang", "Discount")%></span>
                                    </div>
                                </div>

                                <span class="price">
                                    <span class="oldPrice" style="display: <%# iif(ChkNullToDecimal(Eval("PiyasaFiyati")) > 0,"block;","none;") %>">
                                        <asp:Label ID="Label14" runat="server"><%#formatCurTL(CalcKdvDahil(Eval("PiyasaFiyati") * Eval("RateP"), Eval("KdvRate")))%></asp:Label>
                                    </span>

                                    <span class="productPrice">
                                        <%#formatCurTL(CalcKdvDahil(Eval("SatisFiyati1") * Eval("Rate1"), Eval("KdvRate")))%>
                                    </span>
                                </span>
                                <%End If%>
                                <% End If%>
                            </a>
                        </div>
                    </ItemTemplate>

                    <FooterTemplate>
                        </div>
                    </div>
                    </FooterTemplate>
                </asp:Repeater>
            </ItemTemplate>
        </asp:Repeater>
    </div>
</div>
<script type="text/javascript">
    //TABS CONTENT
    $(document).ready(function () {

        $('ul.tabs li').click(function () {
            var tab_id = $(this).attr('data-tab');

            $('ul.tabs li').removeClass('active');
            $('.tab-content').removeClass('active');

            $(this).addClass('active');
            $("#" + tab_id).addClass('active');
        })
    })

    var owl = $(".owl-company-products");
    owl.owlCarousel({
        itemsCustom: [
          [0, 2],
          [450, 2],
          [600, 3],
          [700, 4],
          [1000, 4],
          [1200, 4],
          [1400, 4],
          [1600, 4]
        ],
        singleItem: false,
        mouseDrag: true,
        touchDrag: true,
        navigation: true,
        pagination: false,
        autoHeight: false,
        navigation: true, // Show next and prev buttons
        navigationText: false,
        slideSpeed: 300,
        autoPlay: 3000,
    });
</script>


