﻿$(document).ready(function () {
	$.ajax({
		type: "POST",
		contentType: "application/json; charset=utf-8",
		//url is the path of our web method (Page name/function name)
		url: "/services/MotorBikeList.aspx/MotorBikeLists",
		data: "{}",
		dataType: "json",
		//called on jquery ajax call success
		success: function (result) {
			$('#ddlMotorBikeList').empty();
			$('#ddlMotorBikeList').append("<option value='0'>--Seçiniz--</option>");
			$.each(result.d, function (key, value) {
				$("#ddlMotorBikeList").append($("<option></option>").val(value.MotorId).html(value.MotorName));
			});

			var value = getUrlVars()["YearId"] + "," + getUrlVars()["MotorMarkId"] + "," + getUrlVars()["ModelId"];

			if (value != "") {

				$("#ddlMotorBikeList option[value='" + value + "']").attr("selected", "selected");
			}


		},
		//called on jquery ajax call failure
		error: function ajaxError(result) {
			//alert(result.status + ' : ' + result.statusText);
		}
	});
});

$("#ddlMotorBikeList").change(function () {

	if ($(this).val() != '0') {

		var values = $(this).val().split(',');

		SearchFilter23(values[0], values[1], values[2]);

	}

});

function SearchFilter23(yearid, modelid, markid) {

	var year = yearid;
	var mark = markid;
	var model = modelid;


	var url = window.location.href + '?';


	if (year != null && year > 0) {

		url = UpdateQueryString('YearId', year, url);
	}

	if (mark != null && mark > 0) {

		url = UpdateQueryString('MotorMarkId', mark, url);
	}

	if (model != null && model > 0) {

		url = UpdateQueryString('ModelId', model, url);
	}

	url = url.replace("?&", "?");

	var querry = url.substring(url.indexOf("?"));

	document.location.href = '<%= publicItems.BaseUrl %>' + querry;

}

function UpdateQueryString(key, value, url) {
	if (!url) url = window.location.href;
	var re = new RegExp("([?&])" + key + "=.*?(&|#|$)(.*)", "gi"),
		hash;

	if (re.test(url)) {
		if (typeof value !== 'undefined' && value !== null)
			return url.replace(re, '$1' + key + "=" + value + '$2$3');
		else {
			hash = url.split('#');
			url = hash[0].replace(re, '$1$3').replace(/(&|\?)$/, '');
			if (typeof hash[1] !== 'undefined' && hash[1] !== null)
				url += '#' + hash[1];
			return url;
		}
	}
	else {
		if (typeof value !== 'undefined' && value !== null) {
			var separator = url.indexOf('?') !== -1 ? '&' : '?';
			hash = url.split('#');
			url = hash[0] + separator + key + '=' + value;
			if (typeof hash[1] !== 'undefined' && hash[1] !== null)
				url += '#' + hash[1];
			return url;
		}
		else
			return url;
	}
}

function getUrlVars() {
	var vars = [], hash;
	var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
	for (var i = 0; i < hashes.length; i++) {
		hash = hashes[i].split('=');
		vars.push(hash[0]);
		vars[hash[0]] = hash[1];
	}
	return vars;
}