﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="motoruserlist.ascx.vb" Inherits="ASPNetPortal.motoruserlist" %>
<%@ Register TagPrefix="ew" Namespace="eWorld.UI" Assembly="eWorld.UI" %>
<div id="orderlist" class="module">
    <% If HeaderVisible Then%>
    <div class="moduleTitle">
        <%=ModuleTitle%>
        <% If IsEditable Then%>
        <a href="<%=EditNavigateUrl %>" class="moduleTitleEdit"><%=EditText %></a>
        <% End If%>
    </div>
    <% End If%>
    <div class="moduleContent moduleContentCol1 clearFix">
          <asp:HyperLink ID="lnkAddbtn"  CssClass="lightbox2 button iButton" runat="server"><i class="icon-plus"> Yeni Ekle</i></asp:HyperLink>   
        <div class="formContent clearFix">
            <div class="moduleContentCol3">
                <label>Tanımlanan Motor Adı</label>
                <asp:TextBox ID="txtMotorName" runat="server"></asp:TextBox>
            </div>       
            <div class="moduleContentCol3 inputButton">
                <label><%=GetGlobalResourceObject("lang", "CreatedDate")%> > </label>
                <ew:CalendarPopup ID="Tarih1" runat="server" GoToTodayText="Bu Gün:" ClearDateText="Sil" ShowGoToToday="True" Nullable="True"></ew:CalendarPopup>
            </div>
            <div class="moduleContentCol3 inputButton">
                <label><%=GetGlobalResourceObject("lang", "CreatedDate")%> < </label>
                <ew:CalendarPopup ID="tarih11" runat="server" GoToTodayText="Bu Gün:" ClearDateText="Sil" ShowGoToToday="True" Nullable="True"></ew:CalendarPopup>
            </div>
            <div class="moduleContentCol3">
                <label>&nbsp;</label>
                <asp:Button ID="btnSearch" runat="server" CssClass="button" Text="<%$ Resources:lang, Search%>" />
            </div>
        </div>
        <label>
            <asp:Label ID="msg" runat="server" Visible="False"></asp:Label></label>
        <div class="dataTable">
            <asp:DataGrid ID="Datagrid1" runat="server" AllowPaging="True" AutoGenerateColumns="False" AllowSorting="True" CssClass="datalist" HeaderStyle-CssClass="title" GridLines="none" ItemStyle-CssClass="row">
                <Columns>
                    <asp:BoundColumn DataField="IND" Visible="false" HeaderText="IND"></asp:BoundColumn>
                    <asp:TemplateColumn HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" HeaderStyle-Wrap="false" HeaderText="Tanımlanan Motor Adı">
                        <ItemTemplate>
                         	<a id="lnkCompare" class="lightbox buttonLink" href='<%# BaseUrl & "/store/motoruserdetail.aspx?IND=" & DataBinder.Eval(Container.DataItem, "IND") & "&MID=0&YearId=" & DataBinder.Eval(Container.DataItem, "YearId") & "&MarkId=" & DataBinder.Eval(Container.DataItem, "MarkId") & "&ModelId=" & DataBinder.Eval(Container.DataItem, "ModelId") & "&Name=" & DataBinder.Eval(Container.DataItem, "Name")%>'>
                               <%# Eval("Name")%>
                            </a>
                        </ItemTemplate>
                    </asp:TemplateColumn>  
                    <asp:BoundColumn DataField="CreatedDate" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" DataFormatString="{0:d}" HeaderStyle-Wrap="false" HeaderText="<%$ Resources:lang, CreatedDate%>" SortExpression="CreatedDate"></asp:BoundColumn>
                    <asp:BoundColumn DataField="YearName" HeaderText="Yıl"></asp:BoundColumn>
                    <asp:BoundColumn DataField="MarkName" HeaderText="Marka"></asp:BoundColumn>
                    <asp:BoundColumn DataField="ModelName" HeaderText="Model"></asp:BoundColumn>
                    <asp:TemplateColumn HeaderStyle-HorizontalAlign="center" ItemStyle-HorizontalAlign="Center" HeaderText="<%$ Resources:lang, Delete%>">
                    <ItemTemplate>
                    <asp:LinkButton ID="lnkbtnDelete" CssClass="button iButton" runat="server" CausesValidation="false" CommandName="Delete"><i class="icon-trash"></i></asp:LinkButton>
                    </ItemTemplate>
                    </asp:TemplateColumn>
                </Columns>
                <PagerStyle PageButtonCount="20" Mode="NumericPages" CssClass="dataPager"></PagerStyle>
            </asp:DataGrid>
        </div>

        <div class="dataCount">
            <ul>
                <li><%=GetGlobalResourceObject("lang", "TotalRecords")%> : <b>
                    <asp:Label ID="lblTotalRecord" CssClass="textRed" runat="server"></asp:Label></b></li>
                <li><%=GetGlobalResourceObject("lang", "TotalPages")%> : <b>
                    <asp:Label ID="lblPageCount" CssClass="textRed" runat="server"></asp:Label></b></li>
                <li><%=GetGlobalResourceObject("lang", "CurrentPage")%> : <b>
                    <asp:Label ID="lblCurrentIndex" CssClass="textRed" runat="server"></asp:Label></b></li>
            </ul>
        </div>
        <asp:Label ID="lblSort" runat="server" Visible="False"></asp:Label>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $(".lightbox").colorbox({ width: "900", height: "400", iframe: true, scrolling: false });
    });
    $(document).ready(function () {
        $(".lightbox2").colorbox({ width: "700", height: "500", iframe: true, scrolling: false });
    });

</script>

