"user strict"

$(document).ready(function () {

    var this_js_script = $('script[src*=site]');
    var $markId = this_js_script.attr('data-my_var_mark');
    var $pub = this_js_script.attr('data-my_var_pub');
    var $auth = this_js_script.attr('data-my_var_auth');
    var $catId = this_js_script.attr('data-my_var_cat');
    var intsize = this_js_script.attr('data-my_var_intsize');
    var lang = this_js_script.attr('data-my_var_lang');
    var com = this_js_script.attr('data-my_var_company');
    var $pager = $(".data").pager({ url: "/services/jquery/ProductC2C.ashx?CatId=" + $catId + "&MarkId=" + $markId + "&auth=" + $auth + "&pub=" + $pub + "&LangCode=" + lang + "&CompanyId=" + com }) //create pager jquery object related to selector
    var $ruler = $(".pagination").ruler(); //create ruler jquery object 

	//after it is ready (just like the document object ready function) bind the click events.
	$pager.on("ready", function () {
		$pager.clearAllFilter();
		$pager.addCmpFunction(function (row1, row2) {
			if (row1.ShowOrder < row2.ShowOrder)
				return -1;

			return 1;
		});

		setContent(1);

		$ruler.on("click", "li", function () {
			var pn = $(this).data("item");
			setContent(pn);
		});

		//filters stock
		$("#chkstock").click(function (e) {
			if ($("#chkstock").is(':checked')) {
				$pager.addFilter("chkstock", function (row) {
					if (row.StockQty > 0)
						return true;

					return false;
				});

				setContent(1);
				return;
			} else
				$pager.clearFilterByName("chkstock");

			setContent(1);
		});


		//filters brand
		$brand = $("input[name='chkBrand']");
		$brand.click(function () {
			$pager.clearFilterByName("chkBrand");
			var keyList = [];

			$brand.each(function (index, val) {
				if ($(this).is(":checked"))
					keyList.push($(this).data("mark"));
			});

			if (keyList.length !== 0) {
				$pager.addFilter("chkBrand", function (row) {
					if (keyList.indexOf(row.MarKName) !== -1)
						return true;

					return false;
				});
			}

			setContent(1);
		});


		//filters types
		$type = $("input[name='chkType']");
		$type.click(function () {
			$pager.clearFilterByName("chkType");
			var keyList = [];

			$type.each(function (index, val) {
				if ($(this).is(":checked"))
					keyList.push($(this).data("type"));
			});

			if (keyList.length !== 0) {
				$pager.addFilter("chkType", function (row) {
					var flag = false;
					keyList.forEach(function (val) {

						if (row[val])
							flag = true;
					})
					return flag;
				});
			}

			setContent(1);
		});

		//filters color
		$color = $("input[name='chkColor']");
		$color.click(function () {
			$pager.clearFilterByName("chkColor");
			var keyList = [];

			$color.each(function (index, val) {
				if ($(this).is(":checked"))
					keyList.push($(this).data("color"));
			});

			if (keyList.length !== 0) {
				$pager.addFilter("chkColor", function (row) {
					var flag = false;
					row.Size.forEach(function (val) {
						if (keyList.indexOf(val.Size0Id) !== -1)
							flag = true;
					});

					return flag;
				});
			}

			setContent(1);
		});


		//filters size
		$size = $("input[name='chkSize']");
		$size.click(function () {
			$pager.clearFilterByName("chkSize");
			var keyList = [];

			$size.each(function (index, val) {
				if ($(this).is(":checked"))
					keyList.push($(this).data("size"));
			});

			if (keyList.length !== 0) {
				$pager.addFilter("chkSize", function (row) {
					var flag = false;
					row.Size.forEach(function (val) {
						if (keyList.indexOf(val.Size1Id) !== -1)
							flag = true;
					});

					return flag;
				});
			}

			setContent(1);
		});


		//filters drop
		$drop = $("input[name='chkDrop']");
		$drop.click(function () {
			$pager.clearFilterByName("chkDrop");
			var keyList = [];

			$drop.each(function (index, val) {
				if ($(this).is(":checked"))
					keyList.push($(this).data("drop"));
			});

			if (keyList.length !== 0) {
				$pager.addFilter("chkDrop", function (row) {
					var flag = false;
					row.Size.forEach(function (val) {
						if (keyList.indexOf(val.Size2Id) !== -1)
							flag = true;
					});

					return flag;
				});
			}

			setContent(1);
		});

		//price filter
		var currencyright = $pager.getMaxPrice($pager.filteredList, "CurrencyRight");
		var currencyleft = $pager.getMaxPrice($pager.filteredList, "CurrencyLeft");

		if ($pager.getMaxPrice($pager.filteredList, "SatisFiyati") != 0) {
			$price = $("input[id='minPrice']");
			$price.keyup(function () {
				$pager.clearFilterByName("chkprice");
				setContent(1);
				var minprice = $("input[id='minPrice']").val();
				var maxprice = $("input[id='maxPrice']").val();

				if (maxprice == '')
					maxprice = $pager.getMaxPrice($pager.filteredList, "SatisFiyati");
				if (minprice == '')
					minprice = 0;
				 
				$pager.addFilter("chkprice", function (row) {
					if ((row.SatisFiyati >= minprice) && (row.SatisFiyati <= maxprice))
						return true;
					return false;

				});
				setContent(1);
			});

			$pricemax = $("input[id='maxPrice']");
			$pricemax.keyup(function () {
				$pager.clearFilterByName("chkprice");
				setContent(1);

				var minprice = $("input[id='minPrice']").val();
				var maxprice = $("input[id='maxPrice']").val();

				if (maxprice == '')
					maxprice = $pager.getMaxPrice($pager.filteredList, "SatisFiyati");
				if (minprice == '')
					minprice = 0;
				 
				$pager.addFilter("chkprice", function (row) {
					if ((row.SatisFiyati >= minprice) && (row.SatisFiyati <= maxprice))
						return true;
					return false;

				});
				setContent(1);
			});

		}
		else {
			$(".cat-price").hide();
		}


		//Sorting
		$sortField = $("#sortField").change(function () {
			var field = $(this).val();

			if (field === "Default")
				$pager.clearCmpFunction();
			else if (field === "ProductNameAscending") {
				$pager.addCmpFunction(function (row1, row2) {
					if (row1.ProductName < row2.ProductName)
						return -1;

					return 1;
				});
			} else if (field === "ProductNameDescending") {
				$pager.addCmpFunction(function (row1, row2) {
					if (row1.ProductName > row2.ProductName)
						return -1;

					return 1;
				});
			} else if (field === "PriceAscending") {
				$pager.addCmpFunction(function (row1, row2) {
					if (row1.SatisFiyati < row2.SatisFiyati)
						return -1;

					return 1;
				});
			} else if (field === "PriceDescending") {
				$pager.addCmpFunction(function (row1, row2) {
					if (row1.SatisFiyati > row2.SatisFiyati)
						return -1;

					return 1;
				});
			}

			setContent(1);
		});

	});

	function setContent(pn) { //function to format page data.
		$pager.render(pn);
		if ($pager.isEmpty()) {
		    $(".paging").html('<p class="alert">Bu Kategoride rn Sergilenmemektedir.</p>');
			$pager.html("");
			return;
		}

		var buf = [];

		$.each($pager.pagedList, function (index, val) {
			buf.push('<div class="homeProductContent radius5 moduleContentCol4" >');
				if (val.Url2 == '') {
					buf.push('<div class="productImage"><a href="' + val.ProductUrl + '?CatId=' + val.CatId + '"><img src="/themes/responsive/images/website/loader.gif"  width="300" /><img src="/store/makethumb.aspx?file=' + val.Path + '&intSize=' + intsize + '"  width="300" /></a></div>');
				}
				else {
					buf.push('<div class="productImage"><a href="' + val.ProductUrl + '?CatId=' + val.CatId + '"><img src="/themes/responsive/images/website/loader.gif"  width="300" /><img src="/store/makethumb.aspx?file=' + val.Url2 + '&intSize=' + intsize + '"  width="300" /><img src="/store/makethumb.aspx?file=' + val.Path + '&intSize=' + intsize + '"  width="300" /></a></div>');
				}
				buf.push('<div class="productName"><a href="' + val.ProductUrl + '"">' + val.ProductName + '</a></div>');
				buf.push('<div class="productName"><a href="/selleroffice/company.aspx?IND=' + val.ShopId + '"">' + val.ShopNickName + '</a></div>');
				buf.push('<div class="productPrice">');
				if (val.PiyasaFiyati != 0) {
					buf.push('<span class="old_price">' + val.CurrencyLeft + ' ' + CalcKdvDahil(val.PiyasaFiyati, val.KdvRate).formatMoney(2, ',', '.') + ' ' + val.CurrencyRight + '</span>');
				}
				buf.push('<span>' + val.CurrencyLeft + ' ' + val.SatisFiyati.formatMoney(2, ',', '.') + ' ' + val.CurrencyRight + '</span></div>');

				if (val.Review > 0)
					buf.push('<div class="rate"><img width="84" alt="rating-' + val.Review.toString() + '" src="../assets/images/rating-' + val.Review.toString() + '.png"></div>');

				buf.push('<div id="homelabels"><ul class="clearFix">');
				buf.push('<li id="FirsatUrunu" class="' + val.FirsatUrunu + '">Firsat</li>');
				buf.push('<li id="HizliKargo" class="' + val.HizliKargo + '"></li>');
				buf.push('<li id="EnUcuzUrun" class="' + val.EnUcuzUrun + '">Ucuz</li>');
				buf.push('<li id="AyniGunTeslim" class="' + val.AyniGunTeslim + '">Ayni Gn</li>');
				buf.push('<li id="OzelUrun" class="' + val.OzelUrun + '">zel</li>');
				buf.push('<li id="IndirimliUrun" class="' + val.IndirimliUrun + '">%' + val.Indirim + '</li>');
				buf.push('<li id="SinirliSayidaUrun" class="' + val.SinirliSayidaUrun + '">Sinirli</li>');
				buf.push('<li id="YeniUrun" class="' + val.YeniUrun + '">Yeni</li>');
				buf.push('<li id="SokFiyatliUrun" class="' + val.SokFiyatliUrun + '">Sok</li>');
				buf.push('<li id="HediyeliUrun" class="' + val.HediyeliUrun + '">Hediyeli</li>');
				buf.push('</ul></div>');
	
				buf.push('<div id="productAdd">');
				if (val.StockQty > 0) {
					buf.push('<a id="btnAddToCart" rel="lightbox2" class="button prdct-btn" onclick="AddToCart(' + val.ProductId + ')">Sepete Ekle</a>');
				} 
				else if (val.StockQty <= 0) {
					buf.push('<span id="lblstock" class="stock_out">Stokta Yok !</span>');
				}
				buf.push('</div>');
			

			buf.push('</div>');
		});


		$pager.html(buf.join("\n")); //insert page data 
		$ruler.set({ totalRow: $pager.totalRow(), curPageNo: pn });
		$ruler.display();
		$(".RecordsCount").html("Toplam " + $pager.totalRow() + " rn bulundu. " + pn + ".sayfa grntleniyor.");
	}

});

Number.prototype.formatMoney = function (c, d, t) {
	var n = this,
    c = isNaN(c = Math.abs(c)) ? 2 : c,
    d = d == undefined ? "." : d,
    t = t == undefined ? "," : t,
    s = n < 0 ? "-" : "",
    i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "",
    j = (j = i.length) > 3 ? j % 3 : 0;
	return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
};

function CalcKdvDahil(quantity, percent) {
	var result = quantity + (quantity * percent / 100);
	return result;
}


$(document).ready(function () {

	if (CerezIzin() == false) return;

	var nameEQ = "classdiv=";
	var ca = document.cookie.split(';');
	for (var i = 0; i < ca.length; i++) {
		var c = ca[i];
		while (c.charAt(0) == ' ') c = c.substring(1, c.length);
		if (c.indexOf(nameEQ) == 0)
			$('#clickHome').removeClass().addClass(c.substring(nameEQ.length, c.length));
	}

	function CerezIzin() {
		if (window.navigator.cookieEnabled)
			return true;

		return false;
	}


	function setCookie(name, value, days) {
		if (days) {
			var date = new Date();
			date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
			var expires = "; expires=" + date.toGMTString();
		}
		else var expires = "";
		document.cookie = name + "=" + value + expires + "; path=/";
	}

	$('.collFilter').click(function () {
		$('#clickHome').removeClass().addClass('listContent');
		setCookie("classdiv", "listContent", 1);
	});
	$('.collFilterTwo').click(function () {
		$('#clickHome').removeClass().addClass('twoContent');
		setCookie("classdiv", "twoContent", 1);

	});
	$('.collFilterFour').click(function () {
		$('#clickHome').removeClass().addClass('fourContent');
		setCookie("classdiv", "fourContent", 1);
	});

});

var prm = Sys.WebForms.PageRequestManager.getInstance().add_endRequest(function () {

	if (CerezIzin() == false) return;

	var nameEQ = "classdiv=";
	var ca = document.cookie.split(';');
	for (var i = 0; i < ca.length; i++) {
		var c = ca[i];
		while (c.charAt(0) == ' ') c = c.substring(1, c.length);
		if (c.indexOf(nameEQ) == 0)
			$('#clickHome').removeClass().addClass(c.substring(nameEQ.length, c.length));
	}

	function CerezIzin() {
		if (window.navigator.cookieEnabled)
			return true;

		return false;
	}
	function setCookie(name, value, days) {
		if (days) {
			var date = new Date();
			date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
			var expires = "; expires=" + date.toGMTString();
		}
		else var expires = "";
		document.cookie = name + "=" + value + expires + "; path=/";
	}

	$('.collFilter').click(function () {
		$('#clickHome').removeClass().addClass('listContent');
		setCookie("classdiv", "listContent", 1);
	});
	$('.collFilterTwo').click(function () {
		$('#clickHome').removeClass().addClass('twoContent');
		setCookie("classdiv", "twoContent", 1);

	});

	$('.collFilterFour').click(function () {
		$('#clickHome').removeClass().addClass('fourContent');
		setCookie("classdiv", "fourContent", 1);
	});

});