"user strict"

$.fn.ruler = function (opt) { 
	opt = opt || {};
	var optionList = $.extend({}, $.fn.pager.defaultOptionList, opt);

    //ruler related
    this.rulerList = [];
    this.rulerLen = optionList.rulerLen;
    this.pageLen = optionList.pageLen;
    this.curPageNo = optionList.curPageNo;
	this.totalRow = optionList.totalRow;
	this.totalPage = Math.ceil(this.totalRow / this.pageLen);
    this.rulerHtml = "";

	var self = this;

	self.touchPageNo = function(pageNo) {
		if (pageNo < 1)
			return 1;

		if (pageNo > self.totalPage)
			return self.totalPage;

		return pageNo;
	}

	self.isEmpty = function() {
		if (self.rulerList.length === 0)
			return true;

		return false;
	}

	self.addItem = function(item, label, active, disabled) {
		if (arguments.length !== 4) {
			console.log("wrong number of arguments.");
			return;
		}

		self.rulerList.push({
			item: item,
			label: label,
			active: active,
			disabled: disabled
		});
	}

	self.set = function(opt) {
		self.rulerList = [];

		if (opt.totalRow !== undefined)
			self.totalRow = opt.totalRow;
		if (opt.curPageNo !== undefined)
			self.curPageNo = opt.curPageNo;

		self.totalPage = Math.ceil(this.totalRow / this.pageLen);
		self.curPageNo = self.touchPageNo(self.curPageNo);

		if (self.totalPage < 2)
			return;

		var pageNo = self.touchPageNo(self.curPageNo);
		var startPage = pageNo - self.rulerLen;

		if (startPage < 1)
			startPage = 1;

		var endPage = startPage + self.rulerLen;
		if (endPage > self.totalPage)
			endPage = self.totalPage;

		if (pageNo > 1)
			self.addItem(1, "<<", false, false);
		else
			self.addItem(1, "<<", false, true);
		
		pageNo = self.touchPageNo(startPage - self.rulerLen);
		 
		if (self.touchPageNo(self.curPageNo) > 1)
			self.addItem(self.touchPageNo(self.curPageNo - 1), "<", false, false);
		else
			self.addItem(self.touchPageNo(self.curPageNo - 1), "<", false, true);

		for (var i = startPage; i <= endPage; i++) {
			if (i == self.curPageNo)
	        	self.addItem(i, i, true, false);
	    	else
	            self.addItem(i, i, false, false);
		}

		pageNo = self.touchPageNo(startPage + self.rulerLen);
		//console.log(self.curPageNo);
		if (self.touchPageNo(self.curPageNo) < self.totalPage)
			self.addItem(self.touchPageNo(self.curPageNo + 1), ">", false, false);
		else
			self.addItem(self.touchPageNo(self.curPageNo + 1), ">", false, true);

		if (pageNo < self.totalPage)
        	self.addItem(self.totalPage, ">>", false, false);
		else
            self.addItem(self.totalPage, ">>", false, true);

		self.format();
	}

	self.format = function() {
		if (self.isEmpty())
			return;

		var buf = [];

		buf.push("<ul class='pagination clear'>");

		self.rulerList.forEach(function(elem) {
			var classArr = [];
			if (elem.active)
				classArr.push("active");

			if (elem.disabled)
				classArr.push("disabled");

			var classStr = " class='" + classArr.join(" ") + "'";

			var itemStr = " data-item='" + elem.item + "'";
			buf.push("<li" + classStr + itemStr + ">" + elem.label + "</li>");
		});

		buf.push("</ul>");
		self.rulerHtml = buf.join("\n");
	}

	self.display = function() {
		self.html(self.rulerHtml);
	}

	return this;
};

$.fn.pager.defaultOptionList = {
	"rulerLen": 4,
	"pageLen": 20,
	"curPageNo": 1,
	"totalRow": 0
}
