﻿<%@ WebService Language="VB" Class="ASPNetPortal.motorbike" %>
Imports System.Web
Imports System.Web.Services
Imports System.Web.Services.Protocols
Imports System.Xml
Imports System.Web.Script.Services
Imports System

Imports System.Net
Imports System.Text
Imports System.IO
Imports AjaxControlToolkit
Imports System.Data.SqlClient
'Imports System.Security.Cryptography
Imports System.Collections.Generic
Imports System.Collections.Specialized

Namespace ASPNetPortal
    <WebService(Namespace:="http://tempuri.org/")> _
<WebServiceBinding(ConformsTo:=WsiProfiles.BasicProfile1_1)> _
<ScriptService()> _
    Public Class motorbike
        
        Inherits System.Web.Services.WebService
        
        '   Public YearId As Integer
 
        <WebMethod()> Public Function GetYears(ByVal knownCategoryValues As String, ByVal category As String) As CascadingDropDownNameValue()

            Dim values As New List(Of CascadingDropDownNameValue)()
       
            Dim cnn As New DatabaseDB
			Dim cmd As New SqlClient.SqlCommand("SELECT * FROM MotorYears WHERE IsActive=1  order by YearName desc", cnn.conn)
            cnn.connectDb()
            Dim dr As SqlDataReader
            dr = cmd.ExecuteReader

            While dr.Read()
                Dim YearName As String = CType(dr("YearName"), String)
                Dim YearId As Integer = CType(dr("YearId"), Integer)
                values.Add(New CascadingDropDownNameValue(YearName, YearId.ToString))
            End While
            dr.Close()
            cnn.disconnectDb()
            
            Return values.ToArray

        End Function
    
        <WebMethod(EnableSession:=True)> _
        Public Function GetMarks(ByVal knownCategoryValues As String, ByVal category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)
            'Dim makeId As Integer
            If (Not kv.ContainsKey("YearId")) Then
                Return Nothing
            End If
            Dim values As New List(Of CascadingDropDownNameValue)()
             
            
            Dim cnn As New DatabaseDB
            Dim cmd As New SqlClient.SqlCommand("SELECT * FROM MotorMarks  WHERE IsActive=1 ", cnn.conn)
            'cmd.Parameters.AddWithValue("@YearId", kv("YearId"))
            HttpContext.Current.Session("YearId") = kv("YearId")
            cnn.connectDb()
            Dim dr As SqlDataReader
            dr = cmd.ExecuteReader

            While dr.Read
                Dim MarkName As String = CType(dr("MarkName"), String)
                Dim MarkId As Integer = CType(dr("MarkId"), Integer)
                values.Add(New CascadingDropDownNameValue(MarkName, MarkId.ToString))
            End While
            dr.Close()
            cnn.disconnectDb()
            
            Return values.ToArray

        End Function

        <WebMethod(EnableSession:=True)> _
        Public Function GetModels(ByVal knownCategoryValues As String, ByVal category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)
            'Dim makeId As Integer
            If (Not kv.ContainsKey("MarkId")) Then
                Return Nothing
            End If
            Dim values As New List(Of CascadingDropDownNameValue)()
             
            
            Dim cnn As New DatabaseDB
            Dim cmd As New SqlClient.SqlCommand("SELECT * FROM MotorModels INNER JOIN MotorMarks ON MotorModels.MarkId = MotorMarks.MarkId  INNER JOIN MotorYears ON MotorModels.ContainsYears  LIKE  ('%,'+ CONVERT(nvarchar,MotorYears.YearId) + ',%')  WHERE MotorModels.MarkId=@MarkId AND YearId=@YearId ", cnn.conn)
            cmd.Parameters.AddWithValue("@MarkId", kv("MarkId"))
            cmd.Parameters.AddWithValue("@YearId", Session("YearId"))
            cnn.connectDb()
            Dim dr As SqlDataReader
            dr = cmd.ExecuteReader

            While dr.Read
                Dim ModelName As String = CType(dr("ModelName"), String)
                Dim ModelId As Integer = CType(dr("ModelId"), Integer)
                values.Add(New CascadingDropDownNameValue(ModelName, ModelId.ToString))
            End While
            dr.Close()
            cnn.disconnectDb()
            
            Return values.ToArray

        End Function
        
        <WebMethod()> Public Function GetTypes(ByVal knownCategoryValues As String, ByVal category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)
            'Dim makeId As Integer
    
            Dim values As New List(Of CascadingDropDownNameValue)()
             
            
            Dim cnn As New DatabaseDB
            Dim cmd As New SqlClient.SqlCommand("SELECT * FROM MotorPropertyType WHERE IsActive=1  ", cnn.conn)
            cnn.connectDb()
            Dim dr As SqlDataReader
            dr = cmd.ExecuteReader

            While dr.Read
                Dim TypeName As String = CType(dr("TypeName"), String)
                Dim TypeId As Integer = CType(dr("TypeId"), Integer)
                values.Add(New CascadingDropDownNameValue(TypeName, TypeId.ToString))
            End While
            dr.Close()
            cnn.disconnectDb()
            
            Return values.ToArray

        End Function
        
        <WebMethod()> Public Function GetTypesDetail(ByVal knownCategoryValues As String, ByVal category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)
            'Dim makeId As Integer
            If (Not kv.ContainsKey("TypeId")) Then
                Return Nothing
            End If
            Dim values As New List(Of CascadingDropDownNameValue)()
             
            
            Dim cnn As New DatabaseDB
            Dim cmd As New SqlClient.SqlCommand("SELECT * FROM MotorTypeDetails WHERE IsActive=1 AND TypeId=@TypeId ", cnn.conn)
            cmd.Parameters.AddWithValue("@TypeId", kv("TypeId"))
            cnn.connectDb()
            Dim dr As SqlDataReader
            dr = cmd.ExecuteReader

            While dr.Read
                Dim TypeDetailName As String = CType(dr("TypeDetailName"), String)
                Dim TypeDetailId As Integer = CType(dr("TypeDetailId"), Integer)
                values.Add(New CascadingDropDownNameValue(TypeDetailName, TypeDetailId.ToString))
            End While
            dr.Close()
            cnn.disconnectDb()
            
            Return values.ToArray

        End Function


    End Class

End Namespace