﻿<%@ WebHandler Language="VB" Class="PopsHandler" %>

Imports System
Imports System.Web
Imports System.Web.Script.Serialization
Imports System.Collections.Generic
Imports System.Collections.Specialized
Imports System.Web.UI.TemplateControl
Imports System.Web.UI


Public Class PopsHandler : Implements IHttpHandler, System.Web.SessionState.IReadOnlySessionState
    
	Public Sub ProcessRequest(ByVal context As HttpContext) Implements IHttpHandler.ProcessRequest
		
		If Not HttpContext.Current.Request.Headers("X-Requested-With") Is Nothing And HttpContext.Current.Request.Headers("X-Requested-With") = "XMLHttpRequest" Then
			
			Dim conf As New AppConfig
			Dim time As Integer = 0
		
			If System.Configuration.ConfigurationManager.AppSettings("CacheVitrin") IsNot Nothing Then
				If IsNumeric(conf.GetValue("CacheVitrin", GetType(Integer))) Then
					time = conf.GetValue("CacheVitrin", GetType(Integer))
				End If
			End If
			Dim page As New OutputCachedPage(New OutputCacheParameters() With { _
					.Duration = time, _
					.Location = OutputCacheLocation.Server, _
					.VaryByParam = "CatId;LangCode"})

			page.ProcessRequest(HttpContext.Current)

			context.Response.ContentType = "application/json"
			context.Response.BufferOutput = True
 
			Dim cc As Integer = 0
			If IsNumeric(context.Request("CatId")) Then
				cc = context.Request("CatId")
			End If
			Dim result As String = GetTextile(cc)
			context.Response.ContentType = "application/json"
			context.Response.Write(result)
		Else
			context.Response.ContentType = "application/json"
			context.Response.Write("{""Message"":""Authorization has been denied for this request.""}")
		End If
		
			
	End Sub
 
	Public Class Filter
		Public Color As New List(Of Color)
		Public Size As New List(Of Size)
		Public Drop As New List(Of Drop)
		Public Types As New List(Of Types)
		Public Marks As New List(Of Mark)
		Public Categories As New List(Of Categories)
		Public ParentCategories As New List(Of ParentCategories)
	End Class
 
	Public Class Color
		Public ColorId As Integer
		Public ColorName As String
		Public ColorUrl As String
	End Class
 
	Public Class Size
		Public SizeId As Integer
		Public SizeName As String
	End Class
 
	Public Class Drop
		Public DropId As Integer
		Public DropName As String
	End Class
 
	Public Class Types
		Public TypeId As String
		Public TypeName As String
	End Class
 
	Public Class Mark
		Public MarkId As Integer
		Public MarkName As String
	End Class
	
	
	Public Class Categories
		Public CatId As Integer
		Public CatName As String
		Public CatUrl As String
		Public CatImg As String
		Public Parent As Integer
		Public ChildCount As Integer
		Public ShowMenu2 As Integer
	End Class
 
	Public Class ParentCategories
		Public CatId As Integer
		Public CatName As String
		Public CatUrl As String
		Public CatImg As String
		Public Parent As Integer
		Public ChildCount As Integer
		Public ShowMenu2 As Integer
	End Class
 
	
	Public Shared Function GetTextile(ByVal ccc As Integer) As String
		 
		Dim obj As New Process
		obj.cCatId = ccc
		Return obj.Rslt(ccc)
		
		
	End Function
	 
	Private NotInheritable Class OutputCachedPage
		Inherits Page
		Private _cacheSettings As OutputCacheParameters

		Public Sub New(cacheSettings As OutputCacheParameters)
			' Tracing requires Page IDs to be unique.
			ID = Guid.NewGuid().ToString()
			_cacheSettings = cacheSettings
		End Sub

		Protected Overrides Sub FrameworkInitialize()
			MyBase.FrameworkInitialize()
			InitOutputCache(_cacheSettings)
		End Sub
	End Class
	
	
	Public Class Process
		
		Dim str As String
		Dim dt As New DataTable
		Dim i As Integer
		Public cCatId As Integer
		
		Public Function Rslt(ByVal catId As Integer) As String
		
			Dim con As New DatabaseDB
			con.connectDb()
			
			Dim str2 As String = ""
			Dim sqlcmd As String = "SELECT SatisFiyati1,Currency1,Rate1,CatId,CatName,CatUrl,ProductId,ProductCode,ProductName,StockQty,KdvRate,Path, MarkId,MarKName, " & _
						   "HizliKargo,EnUcuzUrun,AyniGunTeslim,OzelUrun,IndirimliUrun,SinirliSayidaUrun,FirsatUrunu,YeniUrun,SokFiyatliUrun,HediyeliUrun from ProductListLigth WHERE CatId=@CatId and PortalId = @PortalId "

			Dim da As New SqlDataAdapter(sqlcmd, con.conn)
			da.SelectCommand.Parameters.AddWithValue("@PortalId", PortalId)
			da.SelectCommand.Parameters.AddWithValue("@CatId", catId)

			Dim ds As New DataSet
			da.Fill(ds, "urun")

			Dim sqlcmd1 As String = "SELECT ProductSize0ValueId as Size0ValueId,ProductSize1ValueId as Size1ValueId,ProductSize2ValueId as Size2ValueId, ProductSizeList.* from ProductSizeList inner join ProductListLigth  on ProductListLigth.ProductId=ProductSizeList.ProductId  WHERE CatId=@CatId and PortalId = @PortalId and ProductSizeList.StockQty>0"

			Dim da1 As New SqlDataAdapter(sqlcmd1, con.conn)
			da1.SelectCommand.Parameters.AddWithValue("@PortalId", PortalId)
			da1.SelectCommand.Parameters.AddWithValue("@CatId", catId)
			da1.Fill(ds, "tekstil")

			Dim rel As New Data.DataRelation("urun_tekstil", ds.Tables("urun").Columns("ProductId"), ds.Tables("tekstil").Columns("ProductId"))
			ds.Relations.Add(rel)

			Dim dsHelper As New DataSetHelper
			Dim dt As DataTable

			Dim mcolumns As String() = New String() {"Size0ValueId", "Size0Name", "Size0Path"}
			dt = dsHelper.GroupByMultiple(mcolumns, "Size0ValueId", ds.Tables(1).DefaultView.ToTable())
			dt.DefaultView.Sort = "Size0ValueId"
			Dim textile As New List(Of Color)()
			Dim beden As New List(Of Size)()
			Dim drop As New List(Of Drop)()
			Dim types As New List(Of Types)()
			
			For Each sdr As DataRow In dt.Rows
				textile.Add(New Color() With { _
							   .ColorId = sdr("Size0ValueId").ToString(), _
							   .ColorUrl = sdr("Size0Path").ToString(), _
							   .ColorName = sdr("Size0Name").ToString()
				})
			Next
			mcolumns = New String() {"Size1ValueId", "Size1Name"}
			ds.Tables(1).DefaultView.RowFilter = "(Size1Name IS NOT NULL)"
			dt = dsHelper.GroupByMultiple(mcolumns, "Size1ValueId", ds.Tables(1).DefaultView.ToTable())
			dt.DefaultView.Sort = "Size1ValueId"
			For Each sdr As DataRow In dt.Rows
				beden.Add(New Size() With { _
						   .SizeId = sdr("Size1ValueId").ToString(), _
						   .SizeName = sdr("Size1Name").ToString()
				})
			Next
			
			mcolumns = New String() {"Size2ValueId", "Size2Name"}
			ds.Tables(1).DefaultView.RowFilter = "(Size2Name IS NOT NULL)"
			dt = dsHelper.GroupByMultiple(mcolumns, "Size2ValueId", ds.Tables(1).DefaultView.ToTable())
			dt.DefaultView.Sort = "Size2ValueId"
			For Each sdr As DataRow In dt.Rows
				drop.Add(New Drop() With { _
						   .DropId = sdr("Size2ValueId").ToString(), _
						   .DropName = sdr("Size2Name").ToString()
				})
			Next
			
			Dim dtTypes As New DataTable
			dtTypes.Columns.Add("TypeID", Type.GetType("System.Int32"))
			dtTypes.Columns.Add("TypeName", Type.GetType("System.String"))
			dtTypes.Columns.Add("Count", Type.GetType("System.Int32"))
			For i As Integer = 1 To 10
				If ds.Tables(0).DefaultView.Count > 0 Then
					types.Add(New Types() With { _
							   .TypeId = GetTypeName(i), _
							   .TypeName = GetTypeValue(i).ToString()
					})
					'dtTypes.Rows.Add(i, GetTypeValue(i), ds.Tables(0).DefaultView.Count)
				End If
			Next
			Dim dtMark As DataTable
			
			ds.Tables(0).DefaultView.RowFilter = " (MarkId IS NOT NULL) "
			ds.Tables(0).DefaultView.Sort = "MarkName asc"
			ds.Tables(0).DefaultView.Sort = "MarkName"
			 

			Dim mcolumns2 As String() = New String() {"MarkId", "MarkName"}
			dtMark = dsHelper.GroupByMultiple(mcolumns2, "MarkId", ds.Tables(0).DefaultView.ToTable())
			dtMark.DefaultView.Sort = "MarkName"
			Dim mark As New List(Of Mark)()
			
			For Each sdr As DataRow In dtMark.Rows
				mark.Add(New Mark() With { _
							   .MarkId = sdr("MarkId").ToString(), _
								.MarkName = sdr("MarkName").ToString()
				})
			Next
			
			 
			Dim cats As New List(Of Categories)
			Dim catsP As New List(Of ParentCategories)
			Dim str3 As String = ""
			
								 
			If cCatId > 0 Then
                'str2 = "SELECT c.Depth,c.CatImg,c.Parent,c.CatId,d.CatName,d.Url as CatUrl,d.Lineage,d.Description,d.Description2,c.ChildCount,c.ShowMenu1  FROM Categories as c inner join CategoryDescription as d on c.CatId =d.CatId  WHERE IsActive=1 and IsVisible=1 and PortalId=@PortalId and  c.Lineage like @Parent  and d.LanguageCode=@LangCode   ORDER BY c.Parent,isnull(ShowOrder,100),c.CatName  "
				
                str3 = "SELECT c.Depth,c.CatImg,c.Parent,c.CatId,d.CatName,d.Url as CatUrl,d.Lineage,d.Description,d.Description2,c.ChildCount,c.ShowMenu1 FROM dbo.splitstring((select Lineage from CategoryDescription where CatId=@Parent  and LanguageCode=@LangCode ), '/') inner join Categories as c on CatId=Name inner join CategoryDescription as d on c.CatId =d.CatId  WHERE IsActive=1 and IsVisible=1 and PortalId=@PortalId and   d.LanguageCode=@LangCode  ORDER BY c.Parent,isnull(ShowOrder,100),c.CatName "
				
			Else
                'str2 = "SELECT c.Depth,c.CatImg,c.Parent,c.CatId,d.CatName,d.Url as CatUrl,d.Lineage,d.Description,d.Description2,c.ChildCount,c.ShowMenu1  FROM Categories as c inner join CategoryDescription as d on c.CatId =d.CatId  WHERE IsActive=1 and IsVisible=1 and PortalId=@PortalId and (c.depth=0 or c.depth=1)  and d.LanguageCode=@LangCode  ORDER BY c.Parent,isnull(ShowOrder,100),c.CatName  "
			End If
			
            'Dim cmd As New SqlDataAdapter(str2, con.conn)
            'cmd.SelectCommand.Parameters.AddWithValue("@PortalId", PortalId)
            'cmd.SelectCommand.Parameters.AddWithValue("@Parent", "%/" & cCatId & "/%")
            'If HttpContext.Current.Session("UICulture") Is Nothing Then
            '	cmd.SelectCommand.Parameters.AddWithValue("@LangCode", DefaultLangCode)
            'Else
            '	cmd.SelectCommand.Parameters.AddWithValue("@LangCode", ChkNullEmptyString(HttpContext.Current.Session("UICulture").ToString.Split("-")(0)))
            'End If

            Dim daa As New SqlDataAdapter("GetCategoryForPrice", con.conn)
            daa.SelectCommand.CommandType = CommandType.StoredProcedure

            daa.SelectCommand.Parameters.AddWithValue("@CartId", GetShoppingCartId)
            daa.SelectCommand.Parameters.AddWithValue("@Lic", 1)
            daa.SelectCommand.Parameters.AddWithValue("@PortalId", PortalId)
            daa.SelectCommand.Parameters.AddWithValue("@CatId", catId)
            If HttpContext.Current.Session("UICulture") Is Nothing Then
                daa.SelectCommand.Parameters.AddWithValue("@LangCode", DefaultLangCode)
            Else
                daa.SelectCommand.Parameters.AddWithValue("@LangCode", ChkNullEmptyString(HttpContext.Current.Session("UICulture").ToString.Split("-")(0)))
            End If

            Dim dtcat As New DataTable
            'cmd.Fill(dtcat)
            daa.Fill(dtcat)
			
			For Each sdr As DataRow In dtcat.Rows
				cats.Add(New Categories() With { _
							   .CatId = sdr("CatId").ToString(), _
							   .CatName = sdr("CatName").ToString(), _
							   .CatUrl = sdr("CatUrl").ToString().Remove(sdr("CatUrl").ToString().Length - 1, 1).Replace("/kategori/", UseV3SeoCategoryWord) & UseV3SeoExtension,
							   .CatImg = sdr("CatImg").ToString(), _
							   .ChildCount = sdr("ChildCount").ToString(), _
							   .ShowMenu2 = sdr("ShowMenu1"), _
							   .Parent = sdr("Parent")
				})
			Next
			
			If cCatId > 0 Then
				
				Dim cmdp As New SqlDataAdapter(str3, con.conn)
				cmdp.SelectCommand.Parameters.AddWithValue("@PortalId", PortalId)
				cmdp.SelectCommand.Parameters.AddWithValue("@Parent", cCatId)
				If HttpContext.Current.Session("UICulture") Is Nothing Then
					cmdp.SelectCommand.Parameters.AddWithValue("@LangCode", DefaultLangCode)
				Else
					cmdp.SelectCommand.Parameters.AddWithValue("@LangCode", ChkNullEmptyString(HttpContext.Current.Session("UICulture").ToString.Split("-")(0)))
				End If

				Dim dtcatp As New DataTable
				cmdp.Fill(dtcatp)
			
				For Each sdr As DataRow In dtcatp.Rows
					catsP.Add(New ParentCategories() With { _
								   .CatId = sdr("CatId").ToString(), _
								   .CatName = sdr("CatName").ToString(), _
								   .CatUrl = sdr("CatUrl").ToString().Remove(sdr("CatUrl").ToString().Length - 1, 1).Replace("/kategori/", UseV3SeoCategoryWord) & UseV3SeoExtension,
								   .CatImg = sdr("CatImg").ToString(), _
								   .ChildCount = sdr("ChildCount").ToString(), _
								   .ShowMenu2 = sdr("ShowMenu1"), _
								   .Parent = sdr("Parent")
					})
				Next
			
			End If
			

			con.disconnectDb()
			
			
			Dim res As New Filter
			res.Marks = mark
			res.Color = textile
			res.Size = beden
			res.Drop = drop
			res.Types = types
			res.Categories = cats
			res.ParentCategories = catsP
			
			

			Dim mySerializer As New JavaScriptSerializer()
			Dim result As String = mySerializer.Serialize(res)
 
			Return result
			
		End Function
 
		
		Private Function GetTypeValue(ByVal TypeId As String) As String
			Dim Types As New NameValueCollection
			Types.Add("1", "Hızlı Kargo")
			Types.Add("2", "En Ucuz Ürün")
			Types.Add("3", "Aynı Gün Teslim")
			Types.Add("4", "Özel Ürun")
			Types.Add("5", "İndirimli Ürün")
			Types.Add("6", "Sınırlı Sayıda Ürün")
			Types.Add("7", "Fırsat Ürünü")
			Types.Add("8", "Yeni Ürün")
			Types.Add("9", "Şok Fiyatlı Ürün")
			Types.Add("10", "Hediyeli Ürün")

			Return Types(TypeId)
		End Function


		
		Private Function GetTypeName(ByVal TypeId As String) As String
			Dim Types As New NameValueCollection
			Types.Add("1", "HizliKargo")
			Types.Add("2", "EnUcuzUrun")
			Types.Add("3", "AyniGunTeslim")
			Types.Add("4", "OzelUrun")
			Types.Add("5", "IndirimliUrun")
			Types.Add("6", "SinirliSayidaUrun")
			Types.Add("7", "FirsatUrunu")
			Types.Add("8", "YeniUrun")
			Types.Add("9", "SokFiyatliUrun")
			Types.Add("10", "HediyeliUrun")
			Return Types(TypeId)
			
		End Function
		
	End Class
	  
	Public ReadOnly Property IsReusable() As Boolean Implements IHttpHandler.IsReusable
		Get
			Return False
		End Get
	End Property

End Class