﻿<%@ WebService Language="VB" Class="ASPNetPortal.ggVariantSpec" %>
Imports System.Web.Services
Imports System.Web.Script.Services
Imports AjaxControlToolkit
Imports System.Collections.Generic
Imports System.Collections.Specialized

Namespace ASPNetPortal
    <WebService(Namespace:="http://tempuri.org/")>
    <WebServiceBinding(ConformsTo:=WsiProfiles.BasicProfile1_1)>
    <ScriptService()>
    Public Class ggVariantSpec
        <WebMethod>
        Public Function GetCatVariantSpecName(knownCategoryValues As String, category As String) As CascadingDropDownNameValue()

            Dim values As New List(Of CascadingDropDownNameValue)()

            Dim cnn As New DatabaseDB()
            Dim cmd As New SqlCommand("SELECT DISTINCT CatVariantSpecName FROM AlternativeMarketsCatVariantSpec", cnn.conn)
            cnn.connectDb()
            Dim dr As SqlDataReader = Nothing
            dr = cmd.ExecuteReader()

            While dr.Read()
                Dim CatVariantSpecName As String = dr("CatVariantSpecName").ToString()
                values.Add(New CascadingDropDownNameValue(CatVariantSpecName, CatVariantSpecName))
            End While
            dr.Close()
            cnn.disconnectDb()

            Return values.ToArray()

        End Function

        <WebMethod>
        Public Function GetCatVariantSpecValue(knownCategoryValues As String, category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)

            If (Not kv.ContainsKey("CatVariantSpecName")) Then
                Return Nothing
            End If
            Dim values As New List(Of CascadingDropDownNameValue)()


            Dim cnn As New DatabaseDB()
            Dim cmd As New SqlCommand("SELECT DISTINCT Ind,CatVariantSpecValue FROM AlternativeMarketsCatVariantSpec WHERE CatVariantSpecName=@CatVariantSpecName", cnn.conn)
            cmd.Parameters.AddWithValue("@CatVariantSpecName", kv("CatVariantSpecName"))
            cnn.connectDb()
            Dim dr As SqlDataReader = Nothing
            dr = cmd.ExecuteReader()

            While dr.Read()
                Dim CatVariantSpecValue As String = Convert.ToString(dr("CatVariantSpecValue"))
                Dim Ind As Integer = Convert.ToInt32(dr("Ind"))
                values.Add(New CascadingDropDownNameValue(CatVariantSpecValue, Ind.ToString()))
            End While
            dr.Close()
            cnn.disconnectDb()

            Return values.ToArray()

        End Function

        <WebMethod>
        Public Function GetProductSizeOptionName(knownCategoryValues As String, category As String) As CascadingDropDownNameValue()

            Dim values As New List(Of CascadingDropDownNameValue)()

            Dim cnn As New DatabaseDB()
            Dim cmd As New SqlCommand("SELECT ProductSizeOptionId,ProductSizeOptionName FROM ProductSizeOptions WHERE PortalId=@PortalId", cnn.conn)
            cmd.Parameters.AddWithValue("@PortalId", publicItems.PortalId)
            cnn.connectDb()
            Dim dr As SqlDataReader = Nothing
            dr = cmd.ExecuteReader()

            While dr.Read()
                Dim ProductSizeOptionName As String = dr("ProductSizeOptionName").ToString()
                Dim ProductSizeOptionId As Integer = Convert.ToInt32(dr("ProductSizeOptionId"))
                values.Add(New CascadingDropDownNameValue(ProductSizeOptionName, ProductSizeOptionId.ToString()))
            End While
            dr.Close()
            cnn.disconnectDb()

            Return values.ToArray()

        End Function


        <WebMethod>
        Public Function GetProductSizeName(knownCategoryValues As String, category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)
            Dim ProductSizeName As String = Nothing, ProductSizeNameId As String = Nothing

            If (Not kv.ContainsKey("ProductSizeOptionId")) Then
                Return Nothing
            End If
            Dim values As New List(Of CascadingDropDownNameValue)()

            Dim cnn As New DatabaseDB()
            Dim adp As New SqlDataAdapter("set nocount on; SELECT ProductSize0Name,ProductSize1Name,ProductSize2Name FROM ProductSizeOptions WHERE PortalId=@PortalId AND ProductSizeOptionId=@ProductSizeOptionId", cnn.conn)
            adp.SelectCommand.Parameters.AddWithValue("@PortalId", publicItems.PortalId)
            adp.SelectCommand.Parameters.AddWithValue("@ProductSizeOptionId", kv("ProductSizeOptionId"))
            cnn.connectDb()
            Dim dt As New DataTable()
            adp.Fill(dt)
            For Each dtRow As DataRow In dt.Rows
                If Not String.IsNullOrEmpty(dtRow("ProductSize0Name").ToString()) Then
                    ProductSizeName = dtRow("ProductSize0Name").ToString()
                    ProductSizeNameId = "0," + kv("ProductSizeOptionId")
                    values.Add(New CascadingDropDownNameValue(ProductSizeName, ProductSizeNameId.ToString()))
                End If
                If Not String.IsNullOrEmpty(dtRow("ProductSize1Name").ToString()) Then
                    ProductSizeName = dtRow("ProductSize1Name").ToString()
                    ProductSizeNameId = "1," + kv("ProductSizeOptionId")
                    values.Add(New CascadingDropDownNameValue(ProductSizeName, ProductSizeNameId.ToString()))
                End If
                If Not String.IsNullOrEmpty(dtRow("ProductSize2Name").ToString()) Then
                    ProductSizeName = dtRow("ProductSize2Name").ToString()
                    ProductSizeNameId = "2," + kv("ProductSizeOptionId")
                    values.Add(New CascadingDropDownNameValue(ProductSizeName, ProductSizeNameId.ToString()))
                End If
            Next

            cnn.disconnectDb()

            Return values.ToArray()

        End Function

        <WebMethod>
        Public Function GetProductSizeOptionsValueName(knownCategoryValues As String, category As String) As CascadingDropDownNameValue()

            Dim kv As StringDictionary = CascadingDropDown.ParseKnownCategoryValuesString(knownCategoryValues)

            If (Not kv.ContainsKey("ProductSizeNameId")) Then
                Return Nothing
            End If
            Dim values As New List(Of CascadingDropDownNameValue)()

            Dim ProductSizeNameId As String() = kv("ProductSizeNameId").Split(","c)

            Dim cnn As New DatabaseDB()
            Dim cmd As New SqlCommand("SELECT ProductSizeOptionsValueId,ProductSizeOptionsValueName FROM ProductSizeOptionsValues WHERE ProductSizeOptionId=@ProductSizeOptionId AND ProductSizeOptionsSize=@ProductSizeOptionsSize", cnn.conn)
            cmd.Parameters.AddWithValue("@ProductSizeOptionsSize", ProductSizeNameId(0))
            cmd.Parameters.AddWithValue("@ProductSizeOptionId", ProductSizeNameId(1))
            cnn.connectDb()
            Dim dr As SqlDataReader = Nothing
            dr = cmd.ExecuteReader()

            While dr.Read()
                Dim ProductSizeOptionsValueName As String = Convert.ToString(dr("ProductSizeOptionsValueName"))
                Dim ProductSizeOptionsValueId As Integer = Convert.ToInt32(dr("ProductSizeOptionsValueId"))
                values.Add(New CascadingDropDownNameValue(ProductSizeOptionsValueName, ProductSizeOptionsValueId.ToString()))
            End While
            dr.Close()
            cnn.disconnectDb()

            Return values.ToArray()

        End Function

    End Class
End Namespace
