﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="timeCostWork.aspx.vb" Inherits="ASPNETPortal.timeCostWork" %>

<%@ Register TagPrefix="ew" Namespace="eWorld.UI" Assembly="eWorld.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="head1" runat="server">
    <title>Zaman Harcaması Düzenle</title>
</head>
<body>
    <form id="Form1" runat="server">

        <asp:ValidationSummary ID="ValidationSummary1" runat="server" ShowSummary="False" ShowMessageBox="True" ValidationGroup="1"></asp:ValidationSummary>
        <div id="supportDetail" class="pagePopup">
            <div class="boxToggle">
                <div class="toggleTitle">
                    <div class="titleText" runat="server">Zaman Harcaması Düzenle</div>
                </div>
                <div class="toggleContent">
                    <div id="alert" runat="server" visible="false" class="alert alert-info">
                        <asp:Label runat="server" ID="lblMessage"></asp:Label>
                        <asp:Label runat="server" ID="lbl"></asp:Label>

                    </div>

                    <asp:Label runat="server" ID="lblclose"></asp:Label>
                    <div class="dataForm">
                        <div class="row">
                            <div class="colTwo colBtn">
                                <label>
                                    Başlangıç Tarihi : 
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" ErrorMessage="Başlangıç Tarihi belirtiniz." ControlToValidate="txtStartDate" ValidationGroup="1">*</asp:RequiredFieldValidator></label>
                                <ew:CalendarPopup ID="txtStartDate" runat="server" Culture="Turkish (Turkey)" DisableTextBoxEntry="False" Text=">" AllowArbitraryText="False" NullableLabelText="Tarih Giriniz" MonthYearPopupCancelText="İptal" MonthYearPopupApplyText="Uygula" GoToTodayText="Bu gün:" ClearDateText="Sil"></ew:CalendarPopup>

                            </div>
                            <div class="colTwo">
                                <label>
                                    Başlangıç Saati : 
                                    <asp:RequiredFieldValidator ID="Requiredfieldvalidator3" runat="server" ErrorMessage="Başlangıç Saatini belirtiniz." ControlToValidate="txtStartTime" ValidationGroup="1">*</asp:RequiredFieldValidator></label>
                                <ew:MaskedTextBox ID="txtStartTime" runat="server" ErrorMessage="geçersiz giriş" Mask="99:99" Text="00:00"></ew:MaskedTextBox>
                            </div>
                        </div>
                        <div class="row">
                            <div class="colTwo">
                                <label>
                                    Harcanan Süre(Saat):
                                    <asp:RequiredFieldValidator ID="Requiredfieldvalidator7" runat="server" ErrorMessage="Süre belirtiniz." ControlToValidate="txtTime" ValidationGroup="1">*</asp:RequiredFieldValidator></label>
                                <ew:MaskedTextBox ID="txtTime" runat="server" ErrorMessage="geçersiz giriş" Mask="99:99" Text="00:00"></ew:MaskedTextBox>
                            </div>
                            <div class="colTwo">
                                <label runat="server">
                                    <%= GetGlobalResourceObject("admin", "ResponsiblePersonnel") %> : 
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ErrorMessage="<%$ Resources:admin,Select %>" ControlToValidate="ddlUser" InitialValue="0" ValidationGroup="1">*</asp:RequiredFieldValidator></label>
                                <asp:DropDownList runat="server" ID="ddlUser"></asp:DropDownList>
                            </div>
                        </div>
                        <div class="row">
                            <div class="colOne">
                                <label>Üye Adı : </label>
                                <asp:TextBox ID="txtUser" runat="server" autocomplete="off"></asp:TextBox>
                                <cc1:AutoCompleteExtender ID="Userext" runat="server" CompletionInterval="500"
                                    CompletionListCssClass="autocomplete_completionListElement" CompletionListHighlightedItemCssClass="autocomplete_highlightedListItem"
                                    CompletionListItemCssClass="autocomplete_listItem" CompletionSetCount="12" EnableCaching="true"
                                    FirstRowSelected="true" MinimumPrefixLength="2" OnClientItemSelected="UserSelected"
                                    ServiceMethod="GetUsers" ServicePath="/services/MarkService.asmx" TargetControlID="txtUser">
                                </cc1:AutoCompleteExtender>
                                <asp:HiddenField ID="UserHiddenField" runat="server" Value="" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="colOne ">
                                <label>Ürün Adı : </label>
                                <asp:TextBox ID="txtProduct" runat="server" autocomplete="on"></asp:TextBox>
                                <cc1:AutoCompleteExtender ID="Productext" runat="server" CompletionInterval="500" CompletionListCssClass="autocomplete_completionListElement"
                                    CompletionListHighlightedItemCssClass="autocomplete_highlightedListItem" CompletionListItemCssClass="autocomplete_listItem"
                                    CompletionSetCount="12" EnableCaching="true" FirstRowSelected="true" MinimumPrefixLength="2"
                                    OnClientItemSelected="selected" ServiceMethod="GetProducts" ServicePath="~/services/MarkService.asmx"
                                    TargetControlID="txtProduct">
                                </cc1:AutoCompleteExtender>
                                <asp:HiddenField ID="ProductHiddenField" runat="server" Value="" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="colTwo">
                                <label>
                                    Proje :
                                    <asp:RequiredFieldValidator ID="ddlProjectRFV" runat="server" ControlToValidate="ddlProject" ErrorMessage="<%$ Resources:admin,NotEmpty %>" InitialValue="0" ValidationGroup="1">*</asp:RequiredFieldValidator></label>
                                <asp:DropDownList ID="ddlProject" runat="server" AutoPostBack="true"></asp:DropDownList>
                            </div>
                            <div class="colTwo">
                                <label>
                                    İş :
                                    <asp:RequiredFieldValidator ID="ddlJobRFV" runat="server" ControlToValidate="ddlProject" ErrorMessage="<%$ Resources:admin,NotEmpty %>" InitialValue="0" ValidationGroup="1">*</asp:RequiredFieldValidator></label>
                                <asp:DropDownList ID="ddlJob" runat="server"></asp:DropDownList>
                            </div>
                        </div>
                        <div class="row">
                            <div class="colOne">
                                <label runat="server">
                                    Açıklama
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ErrorMessage="<%$ Resources:admin,NotEmpty %>" ControlToValidate="txtCevap" ValidationGroup="1">*</asp:RequiredFieldValidator></label>
                                <asp:TextBox runat="server" TextMode="MultiLine" Rows="10" ID="txtCevap" ValidationGroup="1"></asp:TextBox>
                            </div>
                        </div>
                        <div class="buttonGroup">
                            <asp:Button ID="btnAdd" runat="server" CssClass="btnDefault" Text="Kaydet &amp; Kapat" ValidationGroup="1"></asp:Button>
                            <asp:Button ID="btnCancel" runat="server" CausesValidation="False" CssClass="btnDefault" Text="İptal"></asp:Button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </form>
</body>
</html>
<script type="text/javascript">
    function Customer() {
        popupWindow(940, 700, 50, 'supportUserSelect.aspx?LabelId=lblUserFullName&TextBoxID=txtUserFullName&TextBoxID1=txtUserId&IND=0', 'popup');
    }
    function Stok() {
        popupWindow(940, 700, 50, 'supportProductSelect.aspx?LabelId=lblProductName&TextBoxID=txtProductName&TextBoxID1=txtProductId&IND=0', 'popup');
    }
    function Project() {
        popupWindow(940, 700, 50, 'supportProjectSelect.aspx?LabelId=lblProjectName&TextBoxID=txtProjectName&TextBoxID1=txtProjectId&IND=0', 'popup');
    }
    function Job() {
        popupWindow(940, 700, 50, 'supportJobSelect.aspx?LabelId=lblJobName&TextBoxID=txtJobName&TextBoxID1=txtJobId&IND=0&ProjectId=' + document.getElementById("txtProjectId").value, 'popup');
    }

    function selected(source, eventArgs) {
        hidobj = document.getElementById("<%= ProductHiddenField.ClientID%>");
        hidobj.value = eventArgs.get_value();
    }

    function UserSelected(source, eventArgs) {
        hidobj = document.getElementById("<%=UserHiddenField.ClientID%>");
        hidobj.value = eventArgs.get_value();
    }

</script>
