﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="cTimeCostWork.ascx.vb" Inherits="ASPNETPortal.cTimeCostWork" %>
<%@ Register TagPrefix="ew" Namespace="eWorld.UI" Assembly="eWorld.UI" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>

<div class="pageAdminFreeMails">
    <asp:Label ID="lblAssignedUserMail" runat="server" Visible="false"></asp:Label>
    <asp:Label ID="lblerr" runat="server" />
    <asp:Label ID="lblSort" runat="server" Visible="False"></asp:Label>

    <div class="dataFilter boxToggle">
        <div class="toggleTitle toggleMini">
            <div class="titleTab">
                <ul class="tabMenu">
                    <li><a href="#"><%= GetGlobalResourceObject("admin","Filter") %></a></li>
                </ul>
            </div>
            <div class="titleToggle"></div>
            <div class="titleAdvanced" title="Gelişmiş Arama"><i class="fa fa-search-plus"></i></div>
        </div>
        <div class="toggleContent">
            <div class="tabContent">
                <div class="tab">
                    <div class="colGroup">
                        <div id="alert" runat="server" visible="false" class="alert">
                            <p>
                                <asp:Label runat="server" ID="lblMessage"></asp:Label>
                            </p>
                        </div>
                        <div class="col">
                            <label><%= GetGlobalResourceObject("admin","Personnel") %></label>
                            <asp:DropDownList runat="server" ID="ddlUser"></asp:DropDownList>
                        </div>
                        <div class="col col4">
                            <label><%= GetGlobalResourceObject("admin","StartDate") %></label>
                            <ew:CalendarPopup ID="Tarih1" runat="server" GoToTodayText="Bu Gün:" ClearDateText="Sil" ShowGoToToday="True" Nullable="false" Text=">" DisableTextBoxEntry="False"></ew:CalendarPopup>
                            <ew:CalendarPopup ID="Tarih11" runat="server" GoToTodayText="Bu Gün:" ClearDateText="Sil" ShowGoToToday="True" Nullable="false" Text="<" DisableTextBoxEntry="False"></ew:CalendarPopup>
                        </div>
                        <div class="col col2">
                            <label>Üye Adı</label>
                            <asp:TextBox runat="server" ID="txtUserName"></asp:TextBox>
                            <asp:DropDownList runat="server" ID="ddlUserName">
                                <asp:ListItem Text="<%$ Resources:admin,Contains %>" Value="like '%[]%'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Starts %>" Value="like '[]%'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Ends %>" Value="like '%[]'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Equalss %>" Value="='[]'"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                        <div class="col col2">
                            <label>Ürün Adı</label>
                            <asp:TextBox runat="server" ID="txtProductName"> </asp:TextBox>
                            <asp:DropDownList runat="server" ID="ddlProductName">
                                <asp:ListItem Text="<%$ Resources:admin,Contains %>" Value="like '%[]%'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Starts %>" Value="like '[]%'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Ends %>" Value="like '%[]'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Equalss %>" Value="='[]'"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                        <div class="col col2">
                            <label>Proje</label>
                            <asp:DropDownList ID="ddlProject" runat="server" AutoPostBack="true"></asp:DropDownList>
                        </div>
                        <div class="col col2">
                            <label>İş</label>
                            <asp:DropDownList ID="ddlJob" runat="server"></asp:DropDownList>
                        </div>
                        <div class="col colAuto">
                            <label>&nbsp;</label>
                            <asp:Button runat="server" ID="btnSearch" CssClass="btnDefault" Text="<%$ Resources:admin,Search %>" />
                        </div>
                    </div>
                    <div class="colGroup colGroupAdvanced">
                        <div class="col col4">
                            <label>Açıklama</label>
                            <asp:TextBox runat="server" ID="txtDescription"></asp:TextBox>
                            <asp:DropDownList runat="server" ID="ddlDescription">
                                <asp:ListItem Text="<%$ Resources:admin,Contains %>" Value="like '%[]%'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Starts %>" Value="like '[]%'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Ends %>" Value="like '%[]'"></asp:ListItem>
                                <asp:ListItem Text="<%$ Resources:admin,Equalss %>" Value="='[]'"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="buttonGroup">
        <asp:HyperLink ID="hypnew" runat="Server" CssClass="fancyContent btnDefault"><i class="fa fa-plus"></i> <%= GetGlobalResourceObject("admin", "AddNew") %></asp:HyperLink>
    </div>

    <div class="dataTable">
        <asp:DataGrid ID="timeCostWorkList" runat="server" GridLines="None" PageSize="20" AllowPaging="True" AllowCustomPaging="false" AutoGenerateColumns="False" AllowSorting="True" HeaderStyle-CssClass="title" FooterStyle-HorizontalAlign="Center" FooterStyle-CssClass="textRed" ShowFooter="True">
            <PagerStyle CssClass="dataPager" Mode="NumericPages" PageButtonCount="15"></PagerStyle>
            <Columns>
                <asp:BoundColumn HeaderText="IND" DataField="TimeCostId" SortExpression="TimeCostId" />
                <asp:TemplateColumn HeaderText="Açıklama" SortExpression="Description">
                    <ItemTemplate>
                        <asp:HyperLink ID="HyperLink2" runat="Server" CssClass="btnLink fancyContent" NavigateUrl='<%# "timeCostWork.aspx?IND=" & Container.DataItem("TimeCostId") %> '><%#IIf(Container.DataItem("Description").ToString.Length > 30, Left(Container.DataItem("Description").ToString, 30) & "...", Container.DataItem("Description")) %></asp:HyperLink>
                        <%--<asp:HyperLink ID="HyperLink1" runat="Server" CssClass="btnLink fancyContent" NavigateUrl='<%# "timeCostWork.aspx?IND=" & Container.DataItem("TimeCostId") %> '><%# Container.DataItem("Description") %></asp:HyperLink>--%>
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:BoundColumn HeaderText="Başlangıç Tarihi" HeaderStyle-HorizontalAlign="Center" DataField="StartDate" SortExpression="StartDate" />
                <asp:TemplateColumn HeaderText="Harcanan Süre(Saat)" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" SortExpression="Time">
                    <ItemTemplate>
                        <asp:Label ID="lblTime" runat="server"><%# ConvertDecimaltoHour2(Container.DataItem("Time")).ToString.Replace(",", ":")  %></asp:Label>
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:BoundColumn HeaderText="Sorumlu Personel" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" DataField="AssignerFullName" SortExpression="AssignerFullName" />
                <asp:BoundColumn HeaderText="Üye Adı" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" DataField="FullName" SortExpression="FullName" />
                <asp:BoundColumn HeaderText="Ürün Adı" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" DataField="ProductName" SortExpression="ProductName" />
                <asp:BoundColumn HeaderText="Proje" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" DataField="ProjectName" SortExpression="ProjectName" />
                <asp:BoundColumn HeaderText="İş" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" DataField="JobName" SortExpression="JobName" />
                <asp:TemplateColumn HeaderText="<%$ Resources:admin,Delete %>" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center">
                    <ItemTemplate>
                        <asp:Button ID="btndelete" runat="server" CommandName="Delete" CssClass="btnDefault " Visible='<%# IIf(Format(Eval("StartDate"), "dd.MM.yyyy 00:00:00") = Format(Date.Now, "dd.MM.yyyy 00:00:00"), True, False) %>' Text="<%$ Resources:admin,Delete %>" />
                    </ItemTemplate>
                </asp:TemplateColumn>
            </Columns>
        </asp:DataGrid>
    </div>


    <div class="dataCount">
        <ul>
            <li><%=GetGlobalResourceObject("admin", "TotalRecording")%>:<asp:Label ID="lblTotalRecord" runat="server"></asp:Label></li>
            <li><%=GetGlobalResourceObject("admin", "TotalPage")%>:<asp:Label ID="lblPageCount" runat="server"></asp:Label></li>
            <li><%=GetGlobalResourceObject("admin", "CurrentPage")%>:<asp:Label ID="lblCurrentIndex" runat="server"></asp:Label></li>
        </ul>
    </div>
</div>
