﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="EditSelectYears.aspx.vb" Inherits="EditSelectYears" %>
<html>
<head id="head" runat="server">
<title>Yıl Listesi</title>
</head>
<body>
<form id="form1" runat="server">
<div class="pagePopup">
	<div class="boxToggle">
		<div class="toggleTitle">
			<div class="titleText">Yıl Listesi</div>
		</div>
		<div class="toggleContent">
			<asp:Label ID="msg" runat="server" Visible="False"></asp:Label>
			<asp:Label ID="lblSort" runat="server" Visible="False"></asp:Label>
			<asp:Label ID="lbl" runat="server" Visible="False"></asp:Label>
			<asp:Label ID="lblErr" runat="server"></asp:Label>
			<div class="dataFilter">
				<div class="colGroup">
                    <div class="col col2">
                    <label>Yıl :</label>
							<asp:TextBox ID="txtYear" runat="server"></asp:TextBox>
							<asp:DropDownList ID="ddlYear" runat="server">
								<asp:ListItem Text="<%$ Resources:admin,Contains %>" Value="like '%[]%'"></asp:ListItem>
								<asp:ListItem Text="<%$ Resources:admin,Starts %>" Value="like '[]%'"></asp:ListItem>
								<asp:ListItem Text="<%$ Resources:admin,Ends %>" Value="like '%[]'"></asp:ListItem>
								<asp:ListItem Text="<%$ Resources:admin,Equalss %>" Value="='[]'"></asp:ListItem>
							</asp:DropDownList>
                        </div>
					<div class="col">
						<label>&nbsp;</label>
						<asp:Button ID="btnSearch" runat="server" CssClass="btnDefault" Text="Ara"></asp:Button>
					</div>
				</div>
			</div>
			<div class="dataTable">
			   <asp:DataGrid ID="Datagrid1" runat="server" ShowFooter="true" GridLines="None"  AutoGenerateColumns="False" AllowSorting="True" HeaderStyle-CssClass="title" FooterStyle-HorizontalAlign="Center">
            <PagerStyle Mode="NumericPages" CssClass="dataPager"></PagerStyle>
            <Columns>
                <asp:BoundColumn Visible="False" DataField="YearId" HeaderText="IND"></asp:BoundColumn>
                <asp:BoundColumn DataField="YearName" SortExpression="YearName" HeaderText="Yıl"></asp:BoundColumn>
                <asp:TemplateColumn HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" HeaderText="<%$ Resources:admin,StatusActiveorPassive %>">
                    <ItemTemplate>
                    	<asp:CheckBox ID="chkStatus" runat="server"   Checked='<%# DataBinder.Eval(Container.DataItem, "IsActive") %>' />
                    </ItemTemplate>
                </asp:TemplateColumn>
                <asp:TemplateColumn HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" HeaderText="<%$ Resources:admin,Edit %>">
                    <ItemTemplate>
                    	<asp:HyperLink ID="HyperLink1" runat="Server" CssClass="btnIcon fancyContent" NavigateUrl='<%# "/admin/ecommerce/motor/EditYear.aspx?IND=" & DataBinder.Eval(Container.DataItem, "YearId") & "&YearCode=" & DataBinder.Eval(Container.DataItem, "YearCode") & "&YearName=" & DataBinder.Eval(Container.DataItem, "YearName") & "&Status=" & DataBinder.Eval(Container.DataItem, "IsActive") & ""%> '><i class="fa fa-pencil"></i></asp:HyperLink>
                    </ItemTemplate>
                </asp:TemplateColumn>
                       <asp:TemplateColumn HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" HeaderText="Seç">
                            <ItemTemplate>
                                <asp:CheckBox ToolTip="Yılları Seçiniz" ID="chkSelect" runat="server"></asp:CheckBox>
                            </ItemTemplate>
                            <FooterTemplate>
                                <input id="chkAllItems" type="checkbox" onclick="CheckAllDataGridCheckBoxes('chkSelect', this.checked);" />
                                <%=GetGlobalResourceObject("admin", "All2")%>
                            </FooterTemplate>
                        </asp:TemplateColumn>
            </Columns>
        </asp:DataGrid>
			</div>
			<div class="dataCount">
				<ul>
					<li>Toplam Kayıt: <asp:Label ID="lblTotalRecord" runat="server"></asp:Label></li>
					<li>Toplam Sayfa: <asp:Label ID="lblPageCount" runat="server"></asp:Label></li>
					<li>Geçerli Sayfa: <asp:Label ID="lblCurrentIndex" runat="server"></asp:Label></li>
				</ul>
			</div>
			<div class="buttonGroup">
				 <asp:Button ID="btnSaveExit" runat="server" CssClass="btnDefault" Text="Kapat"></asp:Button>
                 <asp:Button ID="btnCancel" runat="server" CausesValidation="False" CssClass="btnDefault" Text="İptal"></asp:Button>
			</div>
		</div>
	</div>
    </div>
</form>
</body>
</html>